#define _SUPPRESS_PLIB_WARNING 1
#include "EEPROM.h"
#include "definitions.h"
#include <xc.h>            
#include <sys/attribs.h> 
#include "Inductor_Tester.h"

/********************************************************************
*     Function Name:    EEPROM_Init                                 *
*     Parameters:                                                   *
*     Description:      Initialises EEPROM                          *
*                       The toggling of CS is there for debug       *
*                       it will be seen at the start of boot        *
*                                                                   *
********************************************************************/
void EEPROM_Init()
{
  EEPROM_ChipSelect_Assert;                     // Select Device
  CORETIMER_DelayUs(EEPROM_INIT_DELAY);
  EEPROM_ChipSelect_DeAssert;                   // Deselect Device
  CORETIMER_DelayUs(EEPROM_INIT_DELAY);
  EEPROM_ChipSelect_Assert;                     // Select Device
  CORETIMER_DelayUs(EEPROM_INIT_DELAY);
  EEPROM_ChipSelect_DeAssert;  
  CORETIMER_DelayUs(EEPROM_INIT_DELAY);
  EEPROM_ChipSelect_Assert;                     // Select Device
  CORETIMER_DelayUs(EEPROM_INIT_DELAY);
  EEPROM_ChipSelect_DeAssert;                   // Deselect Device
}


/********************************************************************
*     Function Name:    WriteEnable                                 *
*     Return Value:     void                                        *
*     Parameters:       void                                        *
*     Description:      This routine sets the Write Enable Latch    *
********************************************************************/
void WriteEnable(void)
{
    char Wr_En = EEPROM_WREN;
    
    EEPROM_ChipSelect_Assert;                   //Select Device
    SPI2_Write(&Wr_En, 1);
    EEPROM_ChipSelect_DeAssert;                   //Deselect Device
    CORETIMER_DelayUs(1);
}


/********************************************************************
*     Function Name:    LDByteWriteSPI                              *
*     Parameters:       EE memory control, address and pointer 1    *
*     Description:      Writes Data Byte to SPI EE memory device    *
*                       This routine can be used for any SPI        *
*                       EE memory device with 1 byte of address.    *
*                                                                   *
********************************************************************/
//unsigned char LDByteWriteSPI(unsigned char LowAdd, unsigned char Data )
//{
//  WriteEnable();                      // Write Enable prior to Write
//  ReadStatus();                       // Check for WEL bit set
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_WRITE_BYTE );    // Send Write OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );               // write address byte to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, Data );                 // Write Byte to device
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  EEPROM_ChipSelect_DeAssert;                     // Deselect device and initiate Write
//  SPIWIPPolling();                    // Wait for Write to complete
//  SPI1STATbits.SPITBF = 0;
//  return ( 0 );
//}

/********************************************************************
*     Function Name:    LDByteReadSPI                               *
*     Parameters:       EE memory control, address, pointer and     *
*                       length bytes.                               *
*     Description:      Reads data Byte from SPI EE memory device.  *
*                       This routine can be used for any SPI        *
*                       EE memory device with 1 byte of address     *
*                                                                   *
********************************************************************/
//unsigned char LDByteReadSPI(unsigned char LowAdd, unsigned char *rdptr, unsigned char length )
//{
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_READ_BYTE );  // Send Read OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );            // WRITE word address to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  getsSPI( rdptr, length );      // read in multiple bytes
//  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
//  return ( 0 );
//}

/********************************************************************
*     Function Name:    LDPageWriteSPI                              *
*     Parameters:       EE memory control, address and pointer 1    *
*     Description:      Writes data string to SPI EE memory         *
*                       device. This routine can be used for any SPI*
*                       EE memory device with 1 byte of address.    *
*                                                                   *
********************************************************************/
//unsigned char LDPageWriteSPI( unsigned char LowAdd, unsigned char *wrptr )
//{
//  WriteEnable();                      // Write Enable prior to Write
//  ReadStatus();                       // Check for WEL bit set
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_WRITE_BYTE );    // send Write OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );    // write address byte to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PutStringSPI ( wrptr );             // Write Page to device
//  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
//  SPIWIPPolling();                    // Wait for Write to Complete
//  SPI1STATbits.SPITBF = 0;
//  return ( 0 );
//}

/********************************************************************
*     Function Name:    LDSequentialReadSPI                         *
*     Parameters:       EE memory control, address, pointer and     *
*                       length bytes.                               *
*     Description:      Reads data string from SPI EE memory        *
*                       device. This routine can be used for any SPI*
*                       EE memory device with 1 byte of address.    *
*                                                                   *
********************************************************************/
//unsigned char LDSequentialReadSPI( unsigned char LowAdd, unsigned char *rdptr, unsigned char length )
//{
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_READ_BYTE );      // Send Read OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );                // WRITE word address to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  getsSPI( rdptr, length );           // read in multiple bytes
//  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
//  return ( 0 );
//}

/********************************************************************
*     Function Name:    HDByteWriteSPI                              *
*     Parameters:       EE memory control, address and pointer 1    *
*     Description:      Writes data string to SPI EE memory         *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
unsigned char HDByteWriteSPI(unsigned char HighAdd, unsigned char LowAdd, unsigned char Data )
{
  char WR_Byte;  /* byte to write */

  WR_Byte = EEPROM_WRITE_BYTE;
  WriteEnable();                      // Write Enable prior to Write
  CORETIMER_DelayUs(1);
  
  EEPROM_ChipSelect_Assert;                     // Select Device
  SPI2_Write(&WR_Byte, 1);         // Send Write OpCode
  SPI2_Write(&HighAdd,1);          // Send High Address Byte
  SPI2_Write(&LowAdd,1);           // Send High Address Byte
  SPI2_Write(&Data,1);             // Send High Address Byte
  EEPROM_ChipSelect_DeAssert;                         // Deselect Device
  CORETIMER_DelayUs(1);
  SPIWIPPolling();                    // Wait for Write to Complete
  return ( 0 );
}

/********************************************************************
*     Function Name:    HDWordWriteSPI                              *
*     Parameters:       EE memory control, address and pointer 1    *
*     Description:      Writes data string to SPI EE memory         *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
unsigned char HDWordWriteSPI(unsigned int Add, unsigned int Data )
{
  char WR_Byte;  /* byte to write */

  WR_Byte = EEPROM_WRITE_BYTE;
  WriteEnable();                        // Write Enable prior to Write
  CORETIMER_DelayUs(1);

  EEPROM_ChipSelect_Assert;             // Select Device
  SPI2_Write(&WR_Byte, 1);              // Send Write OpCode
  WR_Byte = (char)((Add>>8) & 0xFF);
  SPI2_Write(&WR_Byte,1);  // Send High Address Byte
  WR_Byte = (char)(Add & 0xFF);
  SPI2_Write(&WR_Byte,1);  // Send Low Address Byte

  WR_Byte = (char)(Data & 0xFF);
  SPI2_Write(&WR_Byte,1);    // Write Byte to device
  WR_Byte = (char)((Data>>8) & 0xFF);
  SPI2_Write(&WR_Byte,1);    // Write Byte to device
  WR_Byte = (char)((Data >> 16) & 0xFF);
  SPI2_Write(&WR_Byte,1);    // Write Byte to device
  WR_Byte = (char)((Data >> 24) & 0xFF);
  SPI2_Write(&WR_Byte,1);    // Write Byte to device
  EEPROM_ChipSelect_DeAssert;           // Deselect Device
  CORETIMER_DelayUs(1);
  SPIWIPPolling();                      // Wait for Write to Complete
  return ( 0 );
}


/********************************************************************
*     Function Name:    HDByteReadSPI                               *
*     Parameters:       EE memory control, address, pointer and     *
*                       length bytes.                               *
*     Description:      Reads data string from SPI EE memory        *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
unsigned char HDByteReadSPI(unsigned char HighAdd, unsigned char LowAdd, unsigned char *rdptr, unsigned char length )
{
  char RD_Byte = EEPROM_READ_BYTE;  /* Write command */

  EEPROM_ChipSelect_Assert;                     // Select Device
  SPI2_Write(&RD_Byte, 1);         // Send Write OpCode
  SPI2_Write(&HighAdd,1);       // Send High Address Byte
  SPI2_Write(&LowAdd,1);        // Send High Address Byte
  SPI2_Read(rdptr, 1);           /* clear the read buffer */
  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
  CORETIMER_DelayUs(1);
  return ( 0 );                       // return with no error
}



/********************************************************************
*     Function Name:    HDWordReadSPI                               *
*      Parameters:       EE memory control, address, pointer and     *
*                       length bytes.                               *
*     Description:      Reads data string from SPI EE memory        *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
unsigned char HDWordReadSPI(unsigned int Add, int *rdptr, unsigned char length )
{
  char RD_Byte = EEPROM_READ_BYTE;  /* Write command */

  EEPROM_ChipSelect_Assert;                 // Select Device
  SPI2_Write(&RD_Byte, 1);                  // Send Write OpCode
  RD_Byte = (char)((Add >> 8) & 0xFF);
  SPI2_Write(&RD_Byte,1);  // Send High Address Byte
  RD_Byte = (char)(Add & 0xFF);
  SPI2_Write(&RD_Byte,1);  // Send High Address Byte
  SPI2_Read(rdptr, 4);           /* clear the read buffer */
  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
  CORETIMER_DelayUs(1);
  return ( 0 );                       // return with no error
}



/********************************************************************
*     Function Name:    HDPageWriteSPI                              *
*     Return Value:     error condition status                      *
*     Parameters:       EE memory control, address and pointer 1    *
*     Description:      Writes data string to SPI EE memory         *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
//unsigned char HDPageWriteSPI( unsigned char HighAdd, unsigned char LowAdd, unsigned char *wrptr )
//{
//  WriteEnable();                      // Write Enable prior to Write
//  ReadStatus();                       // Check for WEL bit set
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_WRITE_BYTE );    // send Write OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, HighAdd);               // Send High Address Byte
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );               // write address byte to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);   /* clear the read buffer */
//  PutStringSPI ( wrptr );             // Write Page to device
//  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
//  SPIWIPPolling();                    // Wait for Write to Complete
//  return ( 0 );
//}

//unsigned char MegaHDPageWriteSPI( unsigned char HigherAdd, unsigned char HighAdd, unsigned char LowAdd, unsigned char *wrptr )
//{
//  WriteEnable();                      // Write Enable prior to Write
//  ReadStatus();                       // Check for WEL bit set
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_WRITE_BYTE );    // send Write OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
////  getcSPI1();
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, HigherAdd );
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, HighAdd);               // Send High Address Byte
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );               // write address byte to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  PutStringSPI ( wrptr );             // Write Page to device
//  EEPROM_ChipSelect_DeAssert;                             // Deselect Device
//  SPIWIPPolling();                    // Wait for Write to Complete
//  return ( 0 );
//}

/********************************************************************
*     Function Name:    HDSequentialReadSPI                         *
*     Parameters:       EE memory control, address, pointer and     *
*                       length bytes.                               *
*     Description:      Reads data string from SPI EE memory        *
*                       device. This routine can be used for any SPI*
*                       EE memory device with two address bytes.    *
*                                                                   *
********************************************************************/
//unsigned char HDSequentialReadSPI( unsigned char HighAdd, unsigned char LowAdd, unsigned char *rdptr, unsigned char length )
//{
//  EEPROM_ChipSelect_Assert;                     // Select Device
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, EEPROM_READ_BYTE );      // Send Read OpCode
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, HighAdd);        // Send High Address Byte
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  PLIB_SPI_WRITE_C (EEPROM_SPI_Port, LowAdd );        // WRITE word address to EEPROM
//  PLIB_SPI_BufferRead(EEPROM_SPI_Port);
//  getsSPI( rdptr,length );                    // read in multiple bytes
//  EEPROM_ChipSelect_DeAssert;                     // Deselect Device
//  return ( 0 );
//}


/********************************************************************
*     Function Name:    SPIWIPPolling                               *
*     Return Value:     void                                        *
*     Parameters:       void                                        *
*     Description:      This routine loops until WIP = 0            *
********************************************************************/

void SPIWIPPolling(void)
{
  char Wr_RDStat = EEPROM_READSTAT;
  unsigned char Status;
  
  do
  {
    EEPROM_ChipSelect_Assert;       //Select Device
    SPI2_Write(&Wr_RDStat, 1);       //Read Status Reg OpCode
  //  SPI2_Read(&B_Read, 1);
 //   SPI2_Write(&Wr_NULL, 1);        //Write dummy data to SPI
    SPI2_Read(&Status, 1);
    EEPROM_ChipSelect_DeAssert;                   //Deselect Device
  } while (Status & 0x01);            //Check for WIP bit Set
}


/********************************************************************
*     Function Name:    PutStringSPI                                *
*     Return Value:     void                                        *
*     Parameters:       address of write string storage location    *
*     Description:      This routine writes a string to the SPI bus.*
********************************************************************/
//
//unsigned char PutStringSPI( unsigned char *wrptr )
//{
//  unsigned int x;
//  for (x = 0; x < PageSize; x++ )     // transmit data until PageSize
//  {
//     SPI1BUF = *wrptr++;               // initiate SPI bus cycle
//     while( !SPI1STATbits.SPITBF );        // wait until 'BF' bit is set
//  }
//  return ( 0 );
//}


/********************************************************************
*     Function Name:    Read Status                                 *
*     Return Value:     void                                        *
*     Parameters:       void                                        *
*     Description:      This routine reads the Status Register      *
********************************************************************/
void ReadStatus(void)
{
    char Wr_RDStat = EEPROM_READSTAT;
    char B_Read;
    
    EEPROM_ChipSelect_Assert;                     //Select Device
    SPI2_Write(&Wr_RDStat, 1);
//    SPI2_Read(&B_Read, 1);
//    SPI2_Write(&Wr_NULL, 1);
    SPI2_Read(&B_Read, 1);
    EEPROM_ChipSelect_DeAssert;                   //Deselect Device
}


/********************************************************************
*     Function Name:    getsSPI                                     *
*     Return Value:     void                                        *
*     Parameters:       address of read string storage location and *
*                       length of string bytes to read              *
*     Description:      This routine reads a string from the SPI    *
*                       bus.  The number of bytes to read is deter- *
*                       mined by parameter 'length'.                *
********************************************************************/
//void getsSPI( unsigned char *rdptr, unsigned char length )
//{
//  while ( length )                  // stay in loop until length = 0
//  {
//      PLIB_SPI_WRITE_C (EEPROM_SPI_Port, 0x00 );        //Write dummy data to SPI
//      *rdptr++ =   PLIB_SPI_BufferRead(EEPROM_SPI_Port);   // read a single byte
//      length--;                     // reduce string length count by 1
//  }
//}
//




/* intiialise EEPROM for read / write */
void InitEEPROM()
{
    
}
